#!/usr/bin/env bash

## Validate variables
# $SOURCES_VERSION
# $RELEASE_NUMBER
# $SPEC_FILE
# $OVERRIDE_VERSION_TO_LATEST
# $CCACHE_LINKS_PATH
# $OVERRIDE_PATH
# $ALTERNATE_PATH

#PATH=$CCACHE_PATH:$PATH
#export PATH
set -e 
set -x 

echo "Printing original environmental variables:"
env
echo "End of variables"

ARCH=`uname -m | sed 's/x86_//;s/i[3-6]86/32/'`

case $ENABLE_CCACHE in
        false)
		echo "disabling ccache usage"
		declare -x USE_CCACHE="0"
        ;;
        *)
		echo "using default ccache usage"
#		USE_CCACHE=1
esac

echo -n "USE_CCACHE="
echo $USE_CCACHE

case $CLEAR_CCACHE in
        true)
		echo "Clearing ccache data"
		/usr/bin/ccache -C
        ;;
        *)
		echo "ccache was not cleared"
esac

echo -n "Environment PATH => "
echo $PATH

export PATH=$CCACHE_LINKS_PATH:$PATH
echo -n "Modifed Environment PATH => "
echo $PATH

gcc -v 

case $OVERRIDE_PATH in
        true)
		echo "Using the build parameters PATH"
		PATH=$ALTERNATE_PATH
		export PATH
		echo -n "Modifed Environment PATH => "
		echo $PATH
		gcc -v 
        ;;
        *)
        	echo "Using default PATH"
esac


VERSION_CHECKED="false"
case $OVERRIDE_VERSION_TO_LATEST in
        true)
		#CHECK for $VERSION_BRANCH
		if [ $VERSION_BRANCH == "" ]; then
			echo "missing VERSION_BRANCH variable"
			#return 1
		fi

		# CHECK the latest vesion and set $SOURCES_VERSION
		echo "Checking for latest sources release"
		if [ -x "/usr/bin/ruby" ]
	       	then
			declare -x SOURCES_VERSION=`/usr/bin/ruby check_release.rb $VERSION_BRANCH`
			VERSION_CHECKED="true"
		fi

		if [ -x "/usr/bin/perl" ] && [ "$VERSION_CHECKED" =  "false" ]
	       	then
			declare -x SOURCES_VERSION=`/usr/bin/perl check_release.pl $VERSION_BRANCH`
			VERSION_CHECKED="true"
			echo $SOURCES_VERSION
		fi
        ;;
        *)
        	echo "Using sources for release from the build parameters"
		VERSION_CHECKED="true"
esac

case $VERSION_CHECKED in
	false)
		echo "couldn't check the latest sources version"
		#return 1
	;;
	*)
		echo "sources version was checked against the API or was manully configured"
esac

echo -n "Sources version for the build: "
echo $SOURCES_VERSION

## fetch current stable version from a url
## Download redwood sources(tar.xz+asc) if doesn't exists
echo "trying to see where am I"
pwd

echo -n "SMP FLAGS "
echo $SMP_FLAG

echo "Printing changed environmental variables:"
env
echo "End of variables"

pwd
make builddeb
set +x
set +e
